﻿Type.registerNamespace("View");

// Constructor
View.Hint = function(element) {

    View.Hint.initializeBase(this, [element]);
    
    this.x_pos;
    this.y_pos;
    this._msg;
    this._centerAlignThreshold = 800;
    this._width = 380;
    this._elem_hintcontent = $get("hintcontent");
    this.m_divHintPanel = $get("hintpanel");
}

View.Hint.prototype = 
{
    /// <summary>
	/// This method is to set the style of display
	/// </summary>
    /// <accessibility>public</accessibility>
    /// <param name="isDisplayed">Whether the element should be display</param>
    set_display: function (isDisplayed)
    {
        var dis = isDisplayed ? "" : "none";
        this.get_element().style.display = dis;
    },
    
    /// <summary>
	/// This method is to show the hint box according the paramters
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="base_elem">base element</param>
	/// <param name="msg">content of the hint box</param>
	/// <param name="offsetX">X axes offset to the base element</param>
	/// <param name="offsetY">Y axes offset to the base element</param>
    set_position: function(base_elem,msg,offsetX,offsetY)
    {
        this.x_pos = this.getLeft(base_elem) + offsetX;
        this.y_pos = this.getTop(base_elem) + offsetY;
        this._msg = msg;
        
        if(document.body.scrollWidth < this._centerAlignThreshold)
        {
            this.x_pos = document.body.scrollWidth - this._width;
        }
        
        this.m_divHintPanel.style.left = this.x_pos + "px";
        this.m_divHintPanel.style.top = this.y_pos + "px";
        this.get_element().style.display = gConst_display_inline;
        
        var myNode = document.createTextNode(this._msg);
        if(this._elem_hintcontent.firstChild != null)
        {
            this._elem_hintcontent.removeChild(this._elem_hintcontent.firstChild);
        }
        this._elem_hintcontent.appendChild(myNode); 

    },

    /// <summary>
	/// This method is to get the y offset of the element
	/// </summary>
    /// <accessibility>private</accessibility>
	/// <param name="e">event parameter</param>
    getTop: function(e)
    { 
        var offset=e.offsetTop; 
        if(e.offsetParent!=null) offset+=this.getTop(e.offsetParent); 
        return offset; 
    } ,
    
    /// <summary>
	/// This method is to get the x offset of the element
	/// </summary>
    /// <accessibility>private</accessibility>
	/// <param name="e">event parameter</param>
    getLeft: function(e)
    { 
        var offset=e.offsetLeft; 
        if(e.offsetParent!=null) offset+=this.getLeft(e.offsetParent); 
        return offset; 
    } 

}
View.Hint.registerClass('View.Hint', Sys.UI.Control);

// Since this script is not loaded by System.Web.Handlers.ScriptResourceHandler
// invoke Sys.Application.notifyScriptLoaded to notify ScriptManager 
// that this is the end of the script.
if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();
